import React, { useEffect, useRef, useState } from "react";
import {
  Accordion,
  AccordionHeader,
  AccordionBody,
} from "@material-tailwind/react";
import MapSVG from "../../assets/img/neighbourhood/map.svg";
import Dining from "../../assets/img/neighbourhood/dining.svg";
import Recreation from "../../assets/img/neighbourhood/recreation.svg";
import Schools from "../../assets/img/neighbourhood/schools.svg";
import Shopping from "../../assets/img/neighbourhood/shopping.svg";
import WhiteBar from "../../assets/img/neighbourhood/whitebar.svg";
import North from "../../assets/img/neighbourhood/northicon.svg";
import PurpleDot from "../../assets/img/neighbourhood/purple-dot.svg";
import OrangeDot from "../../assets/img/neighbourhood/orange-dot.svg";
import GreenDot from "../../assets/img/neighbourhood/green-dot.svg";
import BlueDot from "../../assets/img/neighbourhood/blue-dot.svg";
import "./map.css";
import { locations } from "./markers";

const Map = () => {  
	const [open, setOpen] = React.useState(1);
	const handleOpen = (value) => setOpen(open === value ? 0 : value);
	const [category, setCategory] = useState("shopping");
	const shoppingHeight = useRef();
	const diningHeight = useRef();
	const recreationHeight = useRef();
	const schoolsHeight = useRef();
  
	function handlePanelClick(cat) {
		setCategory(cat);
		if (cat === "shopping") {
			shoppingHeight.current.style.height = shoppingHeight.current.scrollHeight + "px";
			diningHeight.current.style.height = "0px";
			recreationHeight.current.style.height = "0px";
			schoolsHeight.current.style.height = "0px";
		}
		else if (cat === "dining") {
			diningHeight.current.style.height = diningHeight.current.scrollHeight + "px";
			shoppingHeight.current.style.height = "0px";
			recreationHeight.current.style.height = "0px";
			schoolsHeight.current.style.height = "0px";
		}
		else if (cat === "recreation") {
			recreationHeight.current.style.height = recreationHeight.current.scrollHeight + "px";
			shoppingHeight.current.style.height = "0px";
			diningHeight.current.style.height = "0px";
			schoolsHeight.current.style.height = "0px";
		}
		else if (cat === "schools") {
			schoolsHeight.current.style.height = schoolsHeight.current.scrollHeight + "px";
			shoppingHeight.current.style.height = "0px";
			diningHeight.current.style.height = "0px";
			recreationHeight.current.style.height = "0px";
		}
		else {
			shoppingHeight.current.style.height = "0px";
			diningHeight.current.style.height = "0px";
			recreationHeight.current.style.height = "0px";
			schoolsHeight.current.style.height = "0px";
		}
	}
	useEffect(() => {
		handlePanelClick("shopping");
		return () => {
		};
	}, []);	
  return (
	<div className="float-right w-[123vw] lg:w-full relative overflow-hidden">
		<img src={MapSVG} className="max-w-[none] w-full"></img>
		<div className="absolute top-0 bottom-0 left-0 right-0">
			<svg 
				  xmlns="http://www.w3.org/2000/svg"
				  xmlSpace="preserve"
				  x="0px" 
				  y="0px"
				  viewBox="0 0 1328.5 894.2"
				  style={{
				  shapeRendering: "geometricPrecision",
				  textRendering: "geometricPrecision",
				  imageRendering: "optimizeQuality",
				  fillRule: "evenodd",
				  clipRule: "evenodd",
				  width: "100%",
				}} 
			  >
				<defs>
				  <style>
					{".st0-shopping{fill-rule:evenodd;clip-rule:evenodd;fill:#A8518A;}.st0-dining{fill-rule:evenodd;clip-rule:evenodd;fill:#F58634;}.st0-recreation{fill-rule:evenodd;clip-rule:evenodd;fill:#00A859;}.st0-school{fill-rule:evenodd;clip-rule:evenodd;fill:#0098DA;}.st1{fill:#FEFEFE;}.st2{fill:none;}"}
				  </style>
				</defs>
				<g id="shopping" className={`${category === "shopping" || category === "all" ? "visible" : "invisible"}`}>
					<g>
						<g className="cursor-pointer" id="shopping-legend-1">
							<circle className="st0-shopping" cx="796" cy="518.2" r="7.6"/>
							<polygon className="st1" points="797.2,522.4 797.2,514 796.3,514 794.7,515.4 794.7,516.4 796.3,515 796.3,522.4 				"/>
						</g>
						<g className="cursor-pointer" id="shopping-legend-2">
							<circle className="st0-shopping" cx="870.2" cy="663.7" r="7.6"/>
							<path className="st1" d="M872.5,667.9v-0.8h-3.6l2.9-3.8c0.5-0.6,0.7-1,0.7-1.7c0-1.4-0.9-2.3-2.3-2.3c-1.4,0-2.3,1-2.3,2.3h0.9
								c0-1.1,0.7-1.5,1.5-1.5c0.9,0,1.5,0.6,1.5,1.5c0,0.5-0.2,0.8-0.5,1.2l-3.3,4.2v0.8H872.5z"/>
						</g>
						<g className="cursor-pointer" id="shopping-legend-3">
							<circle className="st0-shopping" cx="1086.7" cy="280.2" r="7.6"/>
							<path className="st1" d="M1089.1,282.1c0-1.1-0.4-1.7-1.3-2.1c0.8-0.3,1.1-1,1.1-1.9c0-1.4-0.9-2.3-2.3-2.3c-1.3,0-2.3,0.8-2.4,2.2
								h0.8c0.1-0.9,0.6-1.4,1.5-1.4c0.8,0,1.5,0.5,1.5,1.5c0,0.9-0.5,1.5-1.5,1.5h-0.2v0.7h0.2c1.1,0,1.7,0.6,1.7,1.6
								c0,1-0.7,1.6-1.6,1.6c-0.8,0-1.5-0.4-1.6-1.5h-0.9c0.1,1.5,1.1,2.2,2.5,2.2C1088,284.5,1089.1,283.7,1089.1,282.1z"/>
						</g>
						<g className="cursor-pointer" id="shopping-legend-4">
							<circle className="st0-shopping" cx="891.2" cy="843.1" r="7.6"/>
							<polygon className="st1" points="893.8,846 893.8,845.2 892.8,845.2 892.8,842.9 892,842.9 892,845.2 889.5,845.2 892.6,838.9 
								891.6,838.9 888.6,845.2 888.6,846 892,846 892,847.3 892.8,847.3 892.8,846 				"/>
						</g>
						<g className="cursor-pointer" id="shopping-legend-5">
							<circle className="st0-shopping" cx="1163.8" cy="645.7" r="7.6"/>
							<path className="st1" d="M1166.1,647.1c0-0.8-0.1-1.6-0.7-2.3c-0.3-0.3-0.8-0.5-1.5-0.5c-0.7,0-1.2,0.2-1.5,0.6v-2.7h3.5v-0.8h-4.3
								v4.4h0.8c0.2-0.5,0.7-0.8,1.4-0.8c1.2,0,1.4,1,1.4,2c0,0.6,0,1.3-0.5,1.7c-0.2,0.2-0.6,0.4-1,0.4c-0.9,0-1.3-0.5-1.4-1.3h-0.9
								c0,0.6,0.2,1.1,0.6,1.5c0.4,0.4,1,0.6,1.7,0.6c0.7,0,1.3-0.2,1.7-0.6C1166.1,648.8,1166.1,648,1166.1,647.1z"/>
						</g>
						<g className="cursor-pointer" id="shopping-legend-6">
							<circle className="st0-shopping" cx="1146.1" cy="648.7" r="7.6"/>
							<path className="st1" d="M1148.4,650.4c0-1.4-0.9-2.4-2.2-2.4c-0.3,0-0.6,0.1-0.9,0.2l1.9-3.8h-0.9l-2.1,4.2
								c-0.4,0.7-0.5,1.3-0.5,1.9c0,1.5,0.9,2.4,2.3,2.4S1148.4,651.9,1148.4,650.4z M1147.6,650.5c0,1-0.6,1.7-1.5,1.7
								s-1.5-0.7-1.5-1.7c0-1,0.6-1.7,1.5-1.7C1147.1,648.8,1147.6,649.5,1147.6,650.5z"/>
						</g>
						<g className="cursor-pointer" id="shopping-legend-7">
							<circle className="st0-shopping" cx="704.8" cy="367.4" r="7.6"/>
							<path className="st1" d="M707.5,363.7c-0.9,1.6-1.6,3.1-2.1,4.4c-0.5,1.3-0.8,2.5-0.9,3.5h-1c0.1-0.7,0.3-1.4,0.5-2.2
								c0.3-0.8,0.6-1.6,1-2.5c0.4-0.9,0.9-1.9,1.5-3h-4.3v-0.8h5.4V363.7z"/>
						</g>
						<g className="cursor-pointer" id="shopping-legend-8">
							<circle className="st0-shopping" cx="1048.4" cy="859.7" r="7.6"/>
							<path className="st1" d="M1050.9,861.6c0-1-0.5-1.6-1.3-2c0.7-0.4,1.1-1,1.1-1.9c0-1.3-1-2.3-2.3-2.3c-1.3,0-2.3,0.9-2.3,2.3
								c0,0.9,0.4,1.5,1.1,1.9c-0.7,0.4-1.3,1.1-1.3,2c0,1.4,1.1,2.4,2.5,2.4C1049.8,864,1050.9,863,1050.9,861.6z M1050.1,861.6
								c0,0.9-0.7,1.6-1.6,1.6c-0.9,0-1.6-0.7-1.6-1.6c0-0.9,0.7-1.6,1.6-1.6C1049.4,859.9,1050.1,860.6,1050.1,861.6z M1049.9,857.7
								c0,0.9-0.6,1.5-1.5,1.5c-0.9,0-1.5-0.6-1.5-1.5c0-0.9,0.6-1.5,1.5-1.5C1049.3,856.2,1049.9,856.8,1049.9,857.7z"/>
						</g>
					</g>
				</g>
				
				<g id="dining" className={`${category === "dining" || category === "all" ? "visible" : "invisible"}`}>
					<g>
						<circle className="st0-dining" cx="897.1" cy="603.9" r="7.6"/>
						<polygon className="st1" points="898.5,608.1 898.5,599.7 897.3,599.7 895.7,601.1 895.7,602.4 897.3,601 897.3,608.1 			"/>
					</g>
					<g>
						<circle className="st0-dining" cx="897.1" cy="583.2" r="7.6"/>
						<path className="st1" d="M899.4,587.5v-0.8h-3.6l2.9-3.8c0.5-0.6,0.7-1,0.7-1.7c0-1.4-0.9-2.3-2.3-2.3c-1.4,0-2.3,1-2.3,2.3h0.9
							c0-1.1,0.7-1.5,1.5-1.5c0.9,0,1.5,0.6,1.5,1.5c0,0.5-0.2,0.8-0.5,1.2l-3.3,4.2v0.8H899.4z"/>
					</g>
					<g>
						<circle className="st0-dining" cx="872" cy="597.2" r="7.6"/>
						<path className="st1" d="M874.5,599.2c0-1.1-0.4-1.7-1.3-2.1c0.8-0.3,1.1-1,1.1-1.9c0-1.4-0.9-2.3-2.3-2.3c-1.3,0-2.3,0.8-2.4,2.2
							h0.9c0.1-0.9,0.6-1.4,1.5-1.4c0.8,0,1.5,0.5,1.5,1.5c0,0.9-0.5,1.5-1.5,1.5h-0.2v0.7h0.2c1.1,0,1.7,0.6,1.7,1.6
							c0,1-0.7,1.6-1.6,1.6c-0.8,0-1.5-0.4-1.6-1.5h-0.9c0.1,1.5,1.1,2.2,2.5,2.2C873.4,601.5,874.5,600.7,874.5,599.2z"/>
					</g>
					<g>
						<circle className="st0-dining" cx="872" cy="615.7" r="7.6"/>
						<polygon className="st1" points="874.6,618.6 874.6,617.8 873.6,617.8 873.6,615.4 872.8,615.4 872.8,617.8 870.3,617.8 873.4,611.5 
							872.4,611.5 869.4,617.8 869.4,618.6 872.8,618.6 872.8,619.9 873.6,619.9 873.6,618.6 			"/>
					</g>
					<g>
						<circle className="st0-dining" cx="895.6" cy="689.8" r="7.6"/>
						<path className="st1" d="M898,691.2c0-0.8-0.1-1.6-0.7-2.3c-0.3-0.3-0.8-0.5-1.5-0.5c-0.7,0-1.2,0.2-1.5,0.6v-2.7h3.5v-0.8h-4.3v4.4
							h0.8c0.2-0.5,0.7-0.8,1.4-0.8c1.2,0,1.4,1,1.4,2c0,0.6,0,1.3-0.5,1.7c-0.2,0.2-0.6,0.4-1,0.4c-0.9,0-1.3-0.5-1.4-1.3h-0.9
							c0,0.6,0.2,1.1,0.6,1.5c0.4,0.4,1,0.6,1.7,0.6c0.7,0,1.3-0.2,1.7-0.6C897.9,692.8,898,692,898,691.2z"/>
					</g>
					<g>
						<g>
							<circle className="st0-dining" cx="812.9" cy="517.9" r="7.6"/>
							<path className="st1" d="M815.3,519.6c0-1.4-0.9-2.4-2.2-2.4c-0.3,0-0.6,0.1-0.9,0.2l1.9-3.8h-0.9l-2.1,4.2
								c-0.4,0.7-0.5,1.3-0.5,1.9c0,1.5,0.9,2.4,2.3,2.4C814.4,522.1,815.3,521,815.3,519.6z M814.4,519.6c0,1-0.6,1.7-1.5,1.7
								c-0.9,0-1.5-0.7-1.5-1.7c0-1,0.6-1.7,1.5-1.7C813.9,517.9,814.4,518.7,814.4,519.6z"/>
						</g>
						<g>
							<circle className="st0-dining" cx="715.5" cy="239.9" r="7.6"/>
							<path className="st1" d="M718,241.7c0-1-0.5-1.6-1.3-2c0.7-0.4,1.1-1,1.1-1.9c0-1.3-1-2.3-2.3-2.3c-1.3,0-2.3,0.9-2.3,2.3
								c0,0.9,0.4,1.5,1.1,1.9c-0.7,0.4-1.3,1.1-1.3,2c0,1.4,1.1,2.4,2.5,2.4C716.9,244.1,718,243.2,718,241.7z M717.1,241.7
								c0,0.9-0.7,1.6-1.6,1.6c-0.9,0-1.6-0.7-1.6-1.6s0.7-1.6,1.6-1.6C716.4,240.1,717.1,240.8,717.1,241.7z M716.9,237.8
								c0,0.9-0.6,1.5-1.5,1.5c-0.9,0-1.5-0.6-1.5-1.5c0-0.9,0.6-1.5,1.5-1.5C716.3,236.3,716.9,237,716.9,237.8z"/>
						</g>
						<g>
							<circle className="st0-dining" cx="661.6" cy="256.1" r="7.6"/>
							<path className="st1" d="M663.9,254.3c0-1.5-0.9-2.4-2.3-2.4c-1.4,0-2.3,1.1-2.3,2.5c0,1.4,0.9,2.4,2.2,2.4c0.3,0,0.6-0.1,0.9-0.2
								l-1.9,3.8h0.9l2.1-4.2C663.7,255.5,663.9,254.9,663.9,254.3z M663.1,254.3c0,1-0.6,1.7-1.5,1.7c-1,0-1.5-0.8-1.5-1.7
								c0-1,0.6-1.7,1.5-1.7C662.5,252.6,663.1,253.3,663.1,254.3z"/>
						</g>
						<g>
							<circle className="st0-dining" cx="917.1" cy="689.8" r="7.6"/>
							<polygon className="st1" points="919.4,686.3 919.4,685.6 914.7,685.6 914.7,687.7 915.6,687.7 915.6,686.3 918.5,686.3 915.6,694 
								916.5,694 				"/>
						</g>
						<g>
							<circle className="st0-dining" cx="940.6" cy="743.6" r="7.6"/>
							<polygon className="st1" points="938,747.8 938,739.4 937.2,739.4 935.6,740.7 935.6,741.7 937.2,740.3 937.2,747.8 				"/>
							<path id="_x31_" className="st1" d="M945.7,745.5v-3.9c0-1.4-1-2.3-2.3-2.3c-1.3,0-2.3,0.9-2.3,2.3v3.9c0,1.4,1,2.3,2.3,2.3
								C944.7,747.9,945.7,746.9,945.7,745.5z M944.8,745.5c0,0.9-0.5,1.6-1.5,1.6c-0.9,0-1.5-0.7-1.5-1.6v-3.8c0-0.9,0.5-1.6,1.5-1.6
								c0.9,0,1.5,0.7,1.5,1.6V745.5z"/>
						</g>
					</g>
				</g>
				
				<g id="recreation" className={`${category === "recreation" || category === "all" ? "visible" : "invisible"}`}>
					<g>
						<g>
							<circle className="st0-recreation" cx="827.2" cy="575.3" r="7.6"/>
							<path className="st1" d="M829.5,579.6v-0.8h-3.6l2.9-3.8c0.5-0.6,0.7-1,0.7-1.7c0-1.4-0.9-2.3-2.3-2.3c-1.4,0-2.3,1-2.3,2.3h0.9
								c0-1.1,0.7-1.5,1.5-1.5c0.9,0,1.5,0.6,1.5,1.5c0,0.5-0.2,0.8-0.5,1.2l-3.3,4.2v0.8H829.5z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="1021.9" cy="531" r="7.6"/>
							<path className="st1" d="M1024.4,532.9c0-1.1-0.4-1.7-1.3-2.1c0.8-0.3,1.1-1,1.1-1.9c0-1.4-0.9-2.3-2.3-2.3c-1.3,0-2.3,0.8-2.4,2.2
								h0.9c0.1-0.9,0.6-1.4,1.5-1.4c0.8,0,1.5,0.5,1.5,1.5c0,0.9-0.5,1.5-1.5,1.5h-0.2v0.7h0.2c1.1,0,1.7,0.6,1.7,1.6
								c0,1-0.7,1.6-1.6,1.6c-0.8,0-1.5-0.4-1.6-1.5h-0.9c0.1,1.5,1.1,2.2,2.5,2.2C1023.3,535.3,1024.4,534.5,1024.4,532.9z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="1021.2" cy="566" r="7.6"/>
							<polygon className="st1" points="1023.8,568.9 1023.8,568.1 1022.8,568.1 1022.8,565.7 1021.9,565.7 1021.9,568.1 1019.5,568.1 
								1022.5,561.8 1021.6,561.8 1018.6,568.1 1018.6,568.9 1021.9,568.9 1021.9,570.2 1022.8,570.2 1022.8,568.9 				"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="1182.9" cy="485.5" r="7.6"/>
							<path className="st1" d="M1185.2,486.9c0-0.8-0.1-1.6-0.7-2.3c-0.3-0.3-0.8-0.5-1.5-0.5c-0.7,0-1.2,0.2-1.5,0.6V482h3.5v-0.8h-4.3
								v4.4h0.8c0.2-0.5,0.7-0.8,1.4-0.8c1.2,0,1.4,1,1.4,2c0,0.6,0,1.3-0.5,1.7c-0.2,0.2-0.6,0.4-1,0.4c-0.9,0-1.3-0.5-1.4-1.3h-0.9
								c0,0.6,0.2,1.1,0.6,1.5c0.4,0.4,1,0.6,1.7,0.6c0.7,0,1.3-0.2,1.7-0.6C1185.1,488.5,1185.2,487.7,1185.2,486.9z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="1023.1" cy="280.5" r="7.6"/>
							<path className="st1" d="M1025.6,282.4c0-1-0.5-1.6-1.3-2c0.7-0.4,1.1-1,1.1-1.9c0-1.3-1-2.3-2.3-2.3c-1.3,0-2.3,0.9-2.3,2.3
								c0,0.9,0.4,1.5,1.1,1.9c-0.7,0.4-1.3,1.1-1.3,2c0,1.4,1.1,2.4,2.5,2.4S1025.6,283.8,1025.6,282.4z M1024.8,282.3
								c0,0.9-0.7,1.6-1.6,1.6c-0.9,0-1.6-0.7-1.6-1.6c0-0.9,0.7-1.6,1.6-1.6C1024.1,280.7,1024.8,281.4,1024.8,282.3z M1024.6,278.5
								c0,0.9-0.6,1.5-1.5,1.5c-0.9,0-1.5-0.6-1.5-1.5c0-0.9,0.6-1.5,1.5-1.5C1024,276.9,1024.6,277.6,1024.6,278.5z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="675.4" cy="547.3" r="7.6"/>
							<path className="st1" d="M677.7,545.5c0-1.5-0.9-2.4-2.3-2.4s-2.3,1.1-2.3,2.5c0,1.4,0.9,2.4,2.2,2.4c0.3,0,0.6-0.1,0.9-0.2
								l-1.9,3.8h0.9l2.1-4.2C677.5,546.6,677.7,546.1,677.7,545.5z M676.8,545.5c0,1-0.6,1.7-1.5,1.7c-1,0-1.5-0.8-1.5-1.7
								c0-1,0.6-1.7,1.5-1.7C676.2,543.8,676.8,544.5,676.8,545.5z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="776" cy="685.6" r="7.6"/>
							<path className="st1" d="M773.4,689.8v-8.4h-0.9l-1.6,1.4v1l1.6-1.4v7.5H773.4z M781.1,687.6v-3.9c0-1.4-1-2.3-2.3-2.3
								c-1.3,0-2.3,0.9-2.3,2.3v3.9c0,1.4,1,2.3,2.3,2.3C780.1,689.9,781.1,689,781.1,687.6z M780.2,687.5c0,0.9-0.5,1.6-1.5,1.6
								c-0.9,0-1.5-0.7-1.5-1.6v-3.8c0-0.9,0.5-1.6,1.5-1.6c0.9,0,1.5,0.7,1.5,1.6V687.5z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="711.8" cy="297.4" r="7.6"/>
							<path className="st1" d="M709.9,301.7v-8.4h-0.9l-1.6,1.4v1l1.6-1.4v7.5H709.9z M716.1,301.7v-8.4h-0.9l-1.6,1.4v1l1.6-1.4v7.5
								H716.1z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="961" cy="182" r="7.6"/>
							<path className="st1" d="M963.4,183.7c0-1.4-0.9-2.4-2.2-2.4c-0.3,0-0.6,0.1-0.9,0.2l1.9-3.8h-0.9l-2.1,4.2
								c-0.4,0.7-0.5,1.3-0.5,1.9c0,1.5,0.9,2.4,2.3,2.4C962.5,186.2,963.4,185.1,963.4,183.7z M962.5,183.7c0,1-0.6,1.7-1.5,1.7
								c-0.9,0-1.5-0.7-1.5-1.7c0-1,0.6-1.7,1.5-1.7C962,182,962.5,182.8,962.5,183.7z"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="1189.1" cy="161.5" r="7.6"/>
							<polygon className="st1" points="1191.4,158 1191.4,157.3 1186.7,157.3 1186.7,159.3 1187.6,159.3 1187.6,158 1190.5,158 
								1187.6,165.7 1188.5,165.7 				"/>
						</g>
						<g>
							<circle className="st0-recreation" cx="832.9" cy="492.9" r="7.6"/>
							<polygon className="st1" points="834.1,497.1 834.1,488.7 833.2,488.7 831.7,490 831.7,491 833.2,489.6 833.2,497.1 				"/>
						</g>
					</g>
				</g>
				
				<g id="schools" className={`transition-all duration-500 ${category === "schools" || category === "all" ? "visible" : "invisible"}`}>
					<g>
						<g>
							<circle className="st0-school" cx="751.7" cy="334.9" r="7.6"/>
							<path className="st1" d="M754,339.1v-0.8h-3.6l2.9-3.8c0.5-0.6,0.7-1,0.7-1.7c0-1.4-0.9-2.3-2.3-2.3c-1.4,0-2.3,1-2.3,2.3h0.9
								c0-1.1,0.7-1.5,1.5-1.5c0.9,0,1.5,0.6,1.5,1.5c0,0.5-0.2,0.8-0.5,1.2l-3.3,4.2v0.8H754z"/>
						</g>
						<g>
							<circle className="st0-school" cx="1037.2" cy="469" r="7.6"/>
							<path className="st1" d="M1039.6,470.9c0-1.1-0.4-1.7-1.3-2.1c0.8-0.3,1.1-1,1.1-1.9c0-1.4-0.9-2.3-2.3-2.3c-1.3,0-2.3,0.8-2.4,2.2
								h0.9c0.1-0.9,0.6-1.4,1.5-1.4c0.8,0,1.5,0.5,1.5,1.5c0,0.9-0.5,1.5-1.5,1.5h-0.2v0.7h0.2c1.1,0,1.7,0.6,1.7,1.6
								c0,1-0.7,1.6-1.6,1.6c-0.8,0-1.5-0.4-1.6-1.5h-0.9c0.1,1.5,1.1,2.2,2.5,2.2C1038.5,473.3,1039.6,472.5,1039.6,470.9z"/>
						</g>
						<g>
							<circle className="st0-school" cx="1042.8" cy="516.5" r="7.6"/>
							<polygon className="st1" points="1045.4,519.4 1045.4,518.6 1044.4,518.6 1044.4,516.2 1043.6,516.2 1043.6,518.6 1041.1,518.6 
								1044.2,512.3 1043.3,512.3 1040.2,518.6 1040.2,519.4 1043.6,519.4 1043.6,520.7 1044.4,520.7 1044.4,519.4 				"/>
						</g>
						<g>
							<circle className="st0-school" cx="1230.4" cy="400.1" r="7.6"/>
							<path className="st1" d="M1232.7,401.5c0-0.8-0.1-1.6-0.7-2.3c-0.3-0.3-0.8-0.5-1.5-0.5c-0.7,0-1.2,0.2-1.5,0.6v-2.7h3.5v-0.8h-4.3
								v4.4h0.8c0.2-0.5,0.7-0.8,1.4-0.8c1.2,0,1.4,1,1.4,2c0,0.6,0,1.3-0.5,1.7c-0.2,0.2-0.6,0.4-1,0.4c-0.9,0-1.3-0.5-1.4-1.3h-0.9
								c0,0.6,0.2,1.1,0.6,1.5c0.4,0.4,1,0.6,1.7,0.6c0.7,0,1.3-0.2,1.7-0.6C1232.6,403.1,1232.7,402.3,1232.7,401.5z"/>
						</g>
						<g>
							<circle className="st0-school" cx="755.8" cy="531.8" r="7.6"/>
							<polygon className="st1" points="757.1,536 757.1,527.6 756.2,527.6 754.6,528.9 754.6,529.9 756.2,528.5 756.2,536 				"/>
						</g>
						<g>
							<circle className="st0-school" cx="926.9" cy="735.8" r="7.6"/>
							<path className="st1" d="M929.2,737.6c0-1.4-0.9-2.4-2.2-2.4c-0.3,0-0.6,0.1-0.9,0.2l1.9-3.8h-0.9l-2.1,4.2
								c-0.4,0.7-0.5,1.3-0.5,1.9c0,1.5,0.9,2.4,2.3,2.4C928.3,740.1,929.2,739,929.2,737.6z M928.4,737.6c0,1-0.6,1.7-1.5,1.7
								c-0.9,0-1.5-0.7-1.5-1.7c0-1,0.6-1.7,1.5-1.7C927.9,735.9,928.4,736.7,928.4,737.6z"/>
						</g>
						<g>
							<circle className="st0-school" cx="941.2" cy="629.5" r="7.6"/>
							<polygon className="st1" points="943.5,626 943.5,625.3 938.8,625.3 938.8,627.4 939.7,627.4 939.7,626 942.6,626 939.7,633.7 
								940.6,633.7 				"/>
						</g>
						<g>
							<circle className="st0-school" cx="841" cy="689.8" r="7.6"/>
							<path className="st1" d="M843.5,691.7c0-1-0.5-1.6-1.3-2c0.7-0.4,1.1-1,1.1-1.9c0-1.3-1-2.3-2.3-2.3c-1.3,0-2.3,0.9-2.3,2.3
								c0,0.9,0.4,1.5,1.1,1.9c-0.7,0.4-1.3,1.1-1.3,2c0,1.4,1.1,2.4,2.5,2.4C842.4,694.1,843.5,693.1,843.5,691.7z M842.6,691.7
								c0,0.9-0.7,1.6-1.6,1.6c-0.9,0-1.6-0.7-1.6-1.6s0.7-1.6,1.6-1.6C841.9,690,842.6,690.7,842.6,691.7z M842.5,687.8
								c0,0.9-0.6,1.5-1.5,1.5c-0.9,0-1.5-0.6-1.5-1.5c0-0.9,0.6-1.5,1.5-1.5C841.9,686.3,842.5,686.9,842.5,687.8z"/>
						</g>
						<g>
							<circle className="st0-school" cx="870.3" cy="49.1" r="7.6"/>
							<path className="st1" d="M872.6,47.3c0-1.5-0.9-2.4-2.3-2.4c-1.4,0-2.3,1.1-2.3,2.5c0,1.4,0.9,2.4,2.2,2.4c0.3,0,0.6-0.1,0.9-0.2
								l-1.9,3.8h0.9l2.1-4.2C872.5,48.5,872.6,47.9,872.6,47.3z M871.8,47.3c0,1-0.6,1.7-1.5,1.7c-1,0-1.5-0.8-1.5-1.7
								c0-1,0.6-1.7,1.5-1.7C871.2,45.6,871.8,46.3,871.8,47.3z"/>
						</g>
						<g>
							<circle className="st0-school" cx="857.2" cy="62.6" r="7.6"/>
							<path className="st1" d="M854.6,66.8v-8.4h-0.9l-1.6,1.4v1l1.6-1.4v7.5H854.6z M862.3,64.6v-3.9c0-1.4-1-2.3-2.3-2.3
								c-1.3,0-2.3,0.9-2.3,2.3v3.9c0,1.4,1,2.3,2.3,2.3C861.3,66.9,862.3,66,862.3,64.6z M861.4,64.5c0,0.9-0.5,1.6-1.5,1.6
								c-0.9,0-1.5-0.7-1.5-1.6v-3.8c0-0.9,0.5-1.6,1.5-1.6c0.9,0,1.5,0.7,1.5,1.6V64.5z"/>
						</g>
						<g>
							<circle className="st0-school" cx="500.6" cy="88.5" r="7.6"/>
							<path className="st1" d="M498.7,92.7v-8.4h-0.9l-1.6,1.4v1l1.6-1.4v7.5H498.7z M504.9,92.7v-8.4H504l-1.6,1.4v1l1.6-1.4v7.5H504.9z"
								/>
						</g>
						<g>
							<circle className="st0-school" cx="604.7" cy="282.7" r="7.6"/>
							<polygon className="st1" points="602.1,286.9 602.1,278.5 601.2,278.5 599.6,279.9 599.6,280.8 601.2,279.5 601.2,286.9 				"/>
							<path id="_x31__00000081606217914870312680000012269690995614418827_" className="st1" d="M609.8,286.9v-0.8h-3.6l2.9-3.8
								c0.5-0.6,0.7-1,0.7-1.7c0-1.4-0.9-2.3-2.3-2.3c-1.4,0-2.3,1-2.3,2.3h0.9c0-1.1,0.7-1.5,1.5-1.5c0.9,0,1.5,0.6,1.5,1.5
								c0,0.5-0.2,0.8-0.5,1.2l-3.3,4.2v0.8H609.8z"/>
						</g>
					</g>
				</g>
			</svg>
		</div>
		<div className="absolute top-0 left-0 w-[21.5vw] h-full bg-[rgba(255,255,255,0.8)]">
			<div className="relative p-[2.63vw] text-[#A98B68] text-[0.95vw]">
				<div className="relative pb-[1.31vw]">
					{locations.map(({ category, catLabel, markers }, i) => (
					  <Accordion open={open === i + 1} className="" key={i}>
						<AccordionHeader
						  className="border-0 py-0"
						  onClick={() => {
							handleOpen(i + 1);
						  }}
						>
							<div className="flex flex-row items-center">
								{	category === "shopping" ? ()
									
								}
								<img src={PurpleDot} className="flex-none w-[7.32%]"></img>
								<h3 className="flex-1 pl-[5px] text-[1.25vw]">{catLabel}</h3>
							</div>
						  <div className="text-black font-[500] uppercase flex">
							{i !== 4 ? (
							  <span
								className={`inline-block w-[20px] h-[20px] rounded-full border-2 border-white shrink-0 mt-[3px] mr-2 ${colors[i]}`}
							  ></span>
							) : (
							  <span className="inline-block w-[20px] mr-2 mt-[3px]">
								<img src={trainIcon} alt="train" />
							  </span>
							)}

							<span>{catLabel}</span>
						  </div>
						</AccordionHeader>
						<AccordionBody className="py-0 pt-3">
						  <ul>
							{markers.map(({ title, subItems }, j) => (
							  <li
								key={j}
								className="cursor-pointer"
								onClick={() => legendHandler(category, j)}
							  >
								<div className="flex items-start">
								  <span
									className={`relative shrink-0 font-[500] w-[1rem] h-[1rem] rounded-full flex justify-center items-center mr-3 pt-[8px]`}
								  >
									<span>{j + 1}</span>
								  </span>
								  <span className="font-[500] text-base">{title}</span>{" "}
								  <br></br>
								</div>

								<div className="ml-[28px]">
								  {subItems && (
									<span className="font-[500] text-xs">{subItems}</span>
								  )}
								</div>
							  </li>
							))}
						  </ul>
						</AccordionBody>
					  </Accordion>
					))}
					
					
					<div className="flex flex-row items-center" onClick={() => handlePanelClick("shopping")}>
						<img src={PurpleDot} className="flex-none w-[7.32%]"></img>
						<h3 className="flex-1 pl-[5px] text-[1.25vw]">Shopping</h3>
					</div>
					<div ref={shoppingHeight} className={`map-panel ${category === "" ? "" : ""}`}
						>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">1.</div>
							<div className="flex-1 pl-[5px]">Choices Market</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">2.</div>
							<div className="flex-1 pl-[5px]">Safeway Marpole</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">3.</div>
							<div className="flex-1 pl-[5px]">Oakridge Park</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">4.</div>
							<div className="flex-1 pl-[5px]">McArthurGlen Designer Outlet</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">5.</div>
							<div className="flex-1 pl-[5px]">Marine Gateway</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">6.</div>
							<div className="flex-1 pl-[5px]">T&T Superkmarket</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">7.</div>
							<div className="flex-1 pl-[5px]">Save-On-Foods</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">8.</div>
							<div className="flex-1 pl-[5px]">Costco Wholesale</div>
						</div>
					</div>
				</div>
				<div className="relative pb-[7.32%]">
					<div className="flex flex-row items-center transition-all duration-300" onClick={() => handlePanelClick("dining")}>
						<img src={OrangeDot} className="flex-none w-[7.32%]"></img>
						<h3 className="flex-1 pl-[5px] text-[1.25vw]">Dining</h3>
					</div>
					<div ref={diningHeight} className={`map-panel ${category === "dining" ? "active" : ""}`}
						>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">1.</div>
							<div className="flex-1 pl-[5px]">Red Star Seafood Restaurant</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">2.</div>
							<div className="flex-1 pl-[5px]">Delhi Fusion Indian Cuisine</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">3.</div>
							<div className="flex-1 pl-[5px]">Sushi Bar Shu</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">4.</div>
							<div className="flex-1 pl-[5px]">Talay Thai Restaurant</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">5.</div>
							<div className="flex-1 pl-[5px]">Solo Pasta</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">6.</div>
							<div className="flex-1 pl-[5px]">Okini Restaurant & Bar</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">7.</div>
							<div className="flex-1 pl-[5px]">Gigi Blin Market Café</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">8.</div>
							<div className="flex-1 pl-[5px]">Secret Garden Tea Company</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">9.</div>
							<div className="flex-1 pl-[5px]">Ramen DANBO Kerrisdale</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">10.</div>
							<div className="flex-1 pl-[5px]">Café de l’Orangerie</div>
						</div>
					</div>
				</div>
				<div className="relative pb-[7.32%]">
					<div className="flex flex-row items-center transition-all duration-300" onClick={() => handlePanelClick("recreation")}>
						<img src={GreenDot} className="flex-none w-[7.32%]"></img>
						<h3 className="flex-1 pl-[5px] text-[1.25vw]">Recreation</h3>
					</div>
					<div ref={recreationHeight} className={`map-panel ${category === "recreation" ? "active" : ""}`}
						>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">1.</div>
							<div className="flex-1 pl-[5px]">Shannon Mews Park</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">2.</div>
							<div className="flex-1 pl-[5px]">Shannon Park</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">3.</div>
							<div className="flex-1 pl-[5px]">Marpole Oakridge Community Centre</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">4.</div>
							<div className="flex-1 pl-[5px]">Oak Park</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">5.</div>
							<div className="flex-1 pl-[5px]">Langara Golf Course</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">6.</div>
							<div className="flex-1 pl-[5px]">VanDusen Botanical Garden</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">7.</div>
							<div className="flex-1 pl-[5px]">Queen Elizabeth Park & Nat Bailey Stadium</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">8.</div>
							<div className="flex-1 pl-[5px]">Marine Drive Golf Club</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">9.</div>
							<div className="flex-1 pl-[5px]">Fraser River Park (Dog-friendly)</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">10.</div>
							<div className="flex-1 pl-[5px]">Kerrisdale Community Centre</div>
						</div>
					</div>
				</div>
				<div className="relative pb-[7.32%]">
					<div className="flex flex-row items-center transition-all duration-300" onClick={() => handlePanelClick("schools")}>
						<img src={BlueDot} className="flex-none w-[7.32%]"></img>
						<h3 className="flex-1 pl-[5px] text-[1.25vw]">Schools</h3>
					</div>
					<div ref={schoolsHeight} className={`map-panel ${category === "schools" ? "active" : ""}`}
						>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">1.</div>
							<div className="flex-1 pl-[5px]">Dr. R. E. McKechnie Elementary (Catchment)</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">2.</div>
							<div className="flex-1 pl-[5px]">Magee Secondary (Catchment)</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">3.</div>
							<div className="flex-1 pl-[5px]">Sir Winston Churchill Secondary (Catchment – French Immersion)</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">4.</div>
							<div className="flex-1 pl-[5px]">Sir Wilfrid Laurier Elementary</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">5.</div>
							<div className="flex-1 pl-[5px]">Langara College</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">6.</div>
							<div className="flex-1 pl-[5px]">St. Anthony of Padua Catholic Elementary</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">7.</div>
							<div className="flex-1 pl-[5px]">David Lloyd George Elementary</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">8.</div>
							<div className="flex-1 pl-[5px]">Vancouver Montessori School</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">9.</div>
							<div className="flex-1 pl-[5px]">York House School (Private)</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">10.</div>
							<div className="flex-1 pl-[5px]">Little Flower Academy (Private)</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">11.</div>
							<div className="flex-1 pl-[5px]">St. George’s School (Private)</div>
						</div>
						<div className="flex flex-row items-center">
							<div className="flex-none w-[7.32%] text-center">12.</div>
							<div className="flex-1 pl-[5px]">Crofton House School (Private)</div>
						</div>
					</div>
				</div>
				<div className="relative pb-[7.32%]">
					<div className="flex flex-row items-center transition-all duration-300" onClick={() => handlePanelClick("all")}>
						<div className="flex-none w-[7.32%]"></div>
						<h3 className="flex-1 pl-[5px] text-[1.25vw]">All</h3>
					</div>
				</div>
			</div>
		</div>
	</div>
  );
};

export default Map;
